"""
HB_VertexSnap V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_VertexSnap
Description-US: Enables Vertex Snap and disables all other Snapping Modes. [SHIFT: Add Vertex Snap, CTRL: Disable Vertex Snap]

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=27m25s

Name-DE: HB_VertexSnap
Description-DE: Aktiviert Punkt Snap und deaktiviert alle anderen Snapping Modes. [SHIFT: Add Vertex Snap, CTRL: Disable Vertex Snap]

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d
from c4d.modules import snap


def main():

    if not (c4d.IsCommandChecked(440000121)):
        c4d.CallCommand(440000121) # Snapping on

    bc = c4d.BaseContainer()
    mysettings_bc=c4d.BaseContainer()
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc)
    print bc[c4d.BFM_INPUT_QUALIFIER]
    if bc[c4d.BFM_INPUT_QUALIFIER] ==0 or  bc[c4d.BFM_INPUT_QUALIFIER] ==4 :

        c4d.CallCommand(c4d.SNAP_SETTINGS_AUTO)

        snap.EnableSnap(True, doc, c4d.SNAPMODE_POINT)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_EDGE)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_POLYGON)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_SPLINE)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_AXIS)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_INTERSECTION)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_MIDPOINT)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_WORKPLANE)
        snap.EnableSnap(False, doc, c4d.SNAPMODE_GUIDE)

    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 :
        snap.EnableSnap(True, doc, c4d.SNAPMODE_POINT)

    if bc[c4d.BFM_INPUT_QUALIFIER] ==2 :
        snap.EnableSnap(False, doc, c4d.SNAPMODE_POINT)


    c4d.EventAdd()

if __name__=='__main__':
    main()